#ifndef __GUIBasics__
#define __GUIBasics__

/**
 * @file GUIBasics.h
 * @brief Single include for the basics package
 *
 * @date 18/03/2005
 * @author Paul Chana
 * @version 1.0.0 Initial version
 *
 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk\n
 * All content is the Intellectual property of Exp Digital Uk.\n
 * Certain sections of this code may come from other sources. They are credited where applicable.\n
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 *
 * $Id: GUIBasics.h,v 1.4 2007/02/11 02:16:22 paul Exp $
 */


/**
 * @namespace Exponent::GUI::Basics
 * @brief Basic graphics handling routines
 *
 * Contains all the low level graphics classes, such as colours and dialogs
 */

#include "CAlphaColour.hpp"
#include "CColour.hpp"
#include "CDialog.hpp"
#include "ITimedObject.hpp"
#include "GUIDefines.h"

//	===========================================================================

#ifndef EXPONENT_COMPACT_BUILD
	using namespace Exponent::GUI::Basics;
#endif

#endif	// End of GUIBasics.h